function requestFullScreen() {

    if (document.documentElement.requestFullscreen) {
        document.documentElement.requestFullscreen();
    } else if (document.documentElement.msRequestFullscreen) {
        document.documentElement.msRequestFullscreen();
    } else if (document.documentElement.mozRequestFullScreen) {
        document.documentElement.mozRequestFullScreen();
    } else if (document.documentElement.webkitRequestFullscreen) {
        document.documentElement.webkitRequestFullscreen(Element.ALLOW_KEYBOARD_INPUT);
    }
}


function exitFullScreen() {
    if (document.exitFullscreen) {
        document.exitFullscreen();
    } else if (document.msExitFullscreen) {
        document.msExitFullscreen();
    } else if (document.mozCancelFullScreen) {
        document.mozCancelFullScreen();
    } else if (document.webkitExitFullscreen) {
        document.webkitExitFullscreen();
    }
}


document.addEventListener('keyup', function(event) {
    if (event.key == '1') {
        location.reload();
        return;
    }
    if (event.key == '2') {
        requestFullScreen();
        return;
    }

})

document.addEventListener('DOMContentLoaded', function(event) {
    console.log('Enable fullscreen');
    var b = document.createElement('input');
    b.setAttribute('type', 'button');
    b.setAttribute('value', 'Plein-Ecran');
    b.style.position = 'absolute';
    b.style['z-index'] = 100000000;
    b.style['font-size'] = '1.3em';
    b.style.top = '20vh';
    b.style.right = '10vw';
    b.style.width = '33%';
    b.style.position = 'fixed';
    b.style['background-color'] = '#4CAF50';
    b.style['border'] = 'none';
    b.style['color'] = '#F0F0F0';
    b.style['border-radius'] = '5vw';
    b.style['padding'] = '2vw';
    
    b.onclick = function (e) {
        requestFullScreen();
    }
    
    document.body.appendChild(b);

    var r = document.createElement('input');
    r.setAttribute('type', 'button');
    r.setAttribute('value', 'Recharger');
    r.style.position = 'absolute';
    r.style['z-index'] = 100000000;
    r.style['font-size'] = '1.3em';
    r.style.top = '20vh';
    r.style.left = '10vw';
    r.style.width = '33%';
    r.style.position = 'fixed';
    r.style['background-color'] = '#f44336';
    r.style['border'] = 'none';
    r.style['color'] = '#F0F0F0';
    r.style['border-radius'] = '5vw';
    r.style['padding'] = '2vw';

    r.onclick = function (e) {
        location.reload();
    }
    
    document.body.appendChild(r);



    function check_visibility() {


        var isFullScreen = document.webkitIsFullScreen || document.fullscreen || document.mozFullScreen /*|| (1 >= outerHeight - innerHeight)*/;
        //isFullScreen = isFullScreen ||  !window.screenTop || !window.screenY;
        //isFullScreen = isFullScreen || Math.abs(screen.width - window.innerWidth) < 10;
        //console.log('oo', document.fullscreen)
         
//        var isFullScreen = !( Math.abs(screen.width - window.innerWidth) > 10 || window.screenTop || window.screenY );
        
        //console.log(isFullScreen, screen.width,  window.innerWidth);
        if (isFullScreen) {
            b.style.display = 'none';
            r.style.display = 'none';
            //c.style.display = 'none';
        } else {
            b.style.display = 'inline-block';
            r.style.display = 'inline-block';
            //c.style.display = 'inline-block';
        }        
    }
    check_visibility();
    
    document.addEventListener('webkitfullscreenchange', function(e) {
        check_visibility(); }, false);

    document.addEventListener('mozfullscreenchange', function(e) {
        check_visibility(); }, false);

    document.addEventListener('fullscreenchange', function(e) {
        check_visibility(); }, false);

    document.addEventListener('msfullscreenchange', function () {
        check_visibility(); }, false);

    window.addEventListener('resize', function(){
        check_visibility();
    });
   
});
